/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.base;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.network.to_client.PacketUpdateTile;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tile.interfaces.ITileWrapper;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TileEntityUpdateable
extends BlockEntity
implements ITileWrapper {
    @Nullable
    private Coord4D cachedCoord;
    private boolean cacheCoord;

    public TileEntityUpdateable(TileEntityTypeRegistryObject<?> type, BlockPos pos, BlockState state) {
        super((BlockEntityType)type.get(), pos, state);
    }

    protected void cacheCoord() {
        this.cacheCoord = true;
        this.updateCoord();
    }

    @Nonnull
    protected Level getWorldNN() {
        return Objects.requireNonNull(this.m_58904_(), "getWorldNN called before world set");
    }

    public boolean isRemote() {
        return this.getWorldNN().m_5776_();
    }

    public void blockRemoved() {
    }

    public void markDirtyComparator() {
    }

    public final void m_6596_() {
        this.setChanged(true);
    }

    public final void markForSave() {
        this.setChanged(false);
    }

    protected void setChanged(boolean updateComparator) {
        if (this.f_58857_ != null) {
            WorldUtils.markChunkDirty(this.f_58857_, this.f_58858_);
            if (updateComparator && !this.isRemote()) {
                this.markDirtyComparator();
            }
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.getReducedUpdateTag();
    }

    @Nonnull
    public CompoundTag getReducedUpdateTag() {
        return super.m_5995_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.isRemote() && net.getDirection() == PacketFlow.CLIENTBOUND) {
            this.handleUpdatePacket(pkt.m_131708_());
        }
    }

    public void handleUpdatePacket(@Nonnull CompoundTag tag) {
        this.handleUpdateTag(tag);
    }

    public void sendUpdatePacket() {
        this.sendUpdatePacket(this);
    }

    public void sendUpdatePacket(BlockEntity tracking) {
        if (this.isRemote()) {
            Mekanism.logger.warn("Update packet call requested from client side", (Throwable)new IllegalStateException());
        } else if (this.m_58901_()) {
            Mekanism.logger.warn("Update packet call requested for removed tile", (Throwable)new IllegalStateException());
        } else {
            Mekanism.packetHandler().sendToAllTracking(new PacketUpdateTile(this), tracking);
        }
    }

    @Override
    public Level getTileWorld() {
        return this.f_58857_;
    }

    @Override
    public BlockPos getTilePos() {
        return this.f_58858_;
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.updateCoord();
    }

    public void m_142339_(@Nonnull Level world) {
        super.m_142339_(world);
        this.updateCoord();
    }

    private void updateCoord() {
        if (this.cacheCoord && this.f_58857_ != null) {
            this.cachedCoord = new Coord4D((Vec3i)this.f_58858_, this.f_58857_);
        }
    }

    @Override
    public Coord4D getTileCoord() {
        return this.cacheCoord && this.cachedCoord != null ? this.cachedCoord : ITileWrapper.super.getTileCoord();
    }
}

